<?php
require_once('source/session.php');
require_once('source/error.php');
require_once('source/dbconfig.php');
require_once('source/function.php');
require_once('source/restrict_admin.php');

// Check if admin_id is provided
if(!isset($_GET['admin_id'])) {
    $_SESSION['msg'] = "failed";
    $_SESSION['error_message'] = "No admin selected";
    header("Location: list_admin.php");
    exit;
}

$admin_id = (int)$_GET['admin_id'];

// Fetch admin data
$admin_data = sql($DBH, "SELECT * FROM tbl_admin WHERE id = ?", [$admin_id], "rows");
if(empty($admin_data)) {
    $_SESSION['msg'] = "failed";
    $_SESSION['error_message'] = "Admin not found";
    header("Location: list_admin.php");
    exit;
}

$admin = $admin_data[0];

// Message handling
$msg = '';
if(isset($_SESSION['msg'])) {
    $messages = array(
        "updated" => "Admin updated successfully",
        "failed" => "Something went wrong, please try again",
        "password_mismatch" => "Passwords do not match",
        "email_exists" => "Email already exists",
        "username_exists" => "Username already exists"
    );
    
    if(isset($messages[$_SESSION['msg']])) {
        $alert_type = ($_SESSION['msg'] == "updated") ? "success" : "danger";
        $msg = "<div class='alert alert-$alert_type text-center mb-4'>".$messages[$_SESSION['msg']]."</div>";
    }
    unset($_SESSION['msg']);
}

if(isset($_SESSION['error_message'])) {
    $msg = "<div class='alert alert-danger text-center mb-4'>".$_SESSION['error_message']."</div>";
    unset($_SESSION['error_message']);
}

// Get admin full name
$admin_fullname = '';
$rows = sql($DBH, "SELECT fullname FROM tbl_admin WHERE status = ?", ["Active"], "rows");
if(!empty($rows)) {
    $admin_fullname = $rows[0]['fullname'];
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Edit Admin - VERBUM DEI INT'L COLLEGE</title>
  <link rel="icon" type="image/png" href="https://portal.vda.com.ng/coll_admin/coll_logo.jpg">
  
  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  
  <!-- Custom CSS -->
  <style>
    :root {
      --primary-blue: #1976d2;
      --dark-blue: #0d47a1;
      --light-blue: #64b5f6;
      --accent-blue: #bbdefb;
      --bg-light: #e3f2fd;
      --text-dark: #212529;
    }
    
    body {
      font-family: 'Poppins', sans-serif;
      background-color: var(--bg-light);
      min-height: 100vh;
      display: flex;
      flex-direction: column;
    }
    
    /* Navbar Styles */
    .navbar {
      background-color: var(--primary-blue);
      box-shadow: 0 0.15rem 1.75rem 0 rgba(33, 37, 41, 0.1);
      position: fixed;
      top: 0;
      width: 100%;
      z-index: 1030;
      color: white;
    }
    
    .navbar-brand {
      font-weight: 800;
      font-size: 1.2rem;
      color: white;
    }
    
    /* Sidebar Styles */
    .sidebar {
      background: linear-gradient(180deg, var(--dark-blue) 0%, var(--primary-blue) 100%);
      position: fixed;
      top: 56px;
      left: -250px;
      width: 250px;
      height: calc(100vh - 56px);
      transition: all 0.3s;
      z-index: 1000;
      overflow-y: auto;
    }
    
    .sidebar.active {
      left: 0;
    }
    
    .sidebar .nav-link {
      color: rgba(255, 255, 255, 0.85);
      font-weight: 600;
      padding: 0.75rem 1rem;
      margin-bottom: 0.2rem;
      transition: all 0.2s;
    }
    
    .sidebar .nav-link:hover {
      color: #fff;
      background-color: rgba(255, 255, 255, 0.15);
    }
    
    .sidebar .nav-link.active {
      color: #fff;
      background-color: var(--light-blue);
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    
    .sidebar .nav-link i {
      margin-right: 0.5rem;
      width: 20px;
      text-align: center;
    }
    
    /* Main Content Styles */
    .main-content {
      margin-left: 0;
      width: 100%;
      transition: all 0.3s;
      flex: 1 0 auto;
      padding-top: 56px;
    }
    
    @media (min-width: 992px) {
      .sidebar {
        left: 0;
      }
      .main-content {
        margin-left: 250px;
        width: calc(100% - 250px);
      }
    }
    
    /* Card Styles */
    .card {
      border: none;
      border-radius: 12px;
      box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
      margin-bottom: 1.5rem;
      transition: transform 0.3s, box-shadow 0.3s;
    }
    
    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0 1rem 2rem rgba(0, 0, 0, 0.15);
    }
    
    .card-header {
      background-color: var(--accent-blue);
      border-bottom: 1px solid var(--light-blue);
      font-weight: 700;
      color: var(--dark-blue);
      padding: 1rem 1.5rem;
    }
    
    /* Button Styles */
    .btn-primary {
      background-color: var(--primary-blue);
      border-color: var(--primary-blue);
      padding: 0.5rem 1.5rem;
      font-weight: 600;
    }
    
    .btn-primary:hover {
      background-color: var(--dark-blue);
      border-color: var(--dark-blue);
    }
    
    /* Form Styles */
    .form-control, .form-select {
      height: 50px;
      border-radius: 8px;
      padding: 0.5rem 1rem;
      border: 1px solid #ced4da;
      transition: all 0.3s;
    }
    
    .form-control:focus, .form-select:focus {
      border-color: var(--light-blue);
      box-shadow: 0 0 0 0.25rem rgba(100, 181, 246, 0.25);
    }
    
    /* Admin Info Styles */
    .admin-info {
      display: flex;
      align-items: center;
      background-color: rgba(255,255,255,0.2);
      padding: 8px 12px;
      border-radius: 8px;
      color: white;
    }
    
    .admin-name {
      margin-right: 5px;
      font-weight: 600;
    }
    
    .admin-access {
      font-style: italic;
      opacity: 0.8;
      margin-right: 10px;
      font-size: 0.9rem;
    }
    
    .admin-icon {
      font-size: 1.5rem;
      color: white;
    }
    
    /* Footer styles */
    .footer {
      background-color: var(--dark-blue);
      color: white;
      padding: 20px 0;
      flex-shrink: 0;
      width: 100%;
    }
    
    @media (min-width: 992px) {
      .footer {
        margin-left: 250px;
        width: calc(100% - 250px);
      }
    }
    
    .copyright-text {
      font-weight: 600;
      font-size: 1rem;
    }
    
    /* Photo upload preview */
    .photo-preview {
      width: 120px;
      height: 120px;
      object-fit: cover;
      border-radius: 8px;
      border: 2px dashed #dee2e6;
    }
    
    /* Status badges */
    .status-badge {
      padding: 0.35rem 0.65rem;
      border-radius: 50rem;
      font-weight: 600;
    }
    
    .status-badge-active {
      background-color: #28a745;
      color: white;
    }
    
    .status-badge-inactive {
      background-color: #dc3545;
      color: white;
    }
  </style>
</head>

<body>
  <!-- Top Navigation -->
  <nav class="navbar navbar-expand-lg navbar-dark">
    <div class="container-fluid">
      <button id="sidebarToggle" class="btn btn-link d-lg-none me-2">
        <i class="fas fa-bars"></i>
      </button>
      <a class="navbar-brand d-none d-lg-block" href="#">
        VERBUM DEI INT'L COLLEGE
      </a>
      <div class="ms-auto d-flex align-items-center">
        <div class="admin-info me-3">
          <span class="admin-name"><?php echo htmlspecialchars($admin_fullname); ?></span>
          <span class="admin-access">(Administrator)</span>
          <i class="fas fa-user-circle admin-icon"></i>
        </div>
        <a href="logout.php" class="btn btn-sm btn-outline-light">
          <i class="fas fa-sign-out-alt"></i>
        </a>
      </div>
    </div>
  </nav>

  <!-- Sidebar -->
  <nav id="sidebar" class="sidebar">
    <div class="position-sticky pt-3">
      <div class="text-center mb-4 d-none d-lg-block">
        <img src="https://portal.vda.com.ng/coll_admin/coll_logo.jpg" alt="School Logo" class="rounded-circle" width="80">
        <h5 class="mt-2 text-white">VERBUM DEI INT'L COLLEGE</h5>
        <p class="text-white-50 small">Admin Dashboard</p>
      </div>
      
      <ul class="nav flex-column">
        <li class="nav-item">
          <a class="nav-link" href="main.php">
            <i class="fas fa-fw fa-tachometer-alt"></i>
            Admin Centre
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link active" href="list_admin.php">
            <i class="fas fa-fw fa-users-cog"></i>
            Manage Admins
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_session.php">
            <i class="fas fa-fw fa-calendar-alt"></i>
            School Year/Session
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_classes.php">
            <i class="fas fa-fw fa-building"></i>
            Manage Classes
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="add_students.php">
            <i class="fas fa-fw fa-user-plus"></i>
            Register New Student
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_subjects.php">
            <i class="fas fa-fw fa-book"></i>
            Create Subjects
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="teachers.php">
            <i class="fas fa-fw fa-chalkboard-teacher"></i>
            Manage Teachers
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="students.php">
            <i class="fas fa-fw fa-users"></i>
            Manage Students
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="deactivate_students.php">
            <i class="fas fa-fw fa-user-lock"></i>
            Activate/Deactivate
          </a>
        </li>
      </ul>
    </div>
  </nav>

  <!-- Main Content -->
  <main class="main-content">
    <div class="container-fluid px-4 pt-4">
      <!-- Page Heading -->
      <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Edit Admin</h1>
        <div class="d-none d-sm-inline-block">
          <span class="badge support-badge p-2">
            <i class="fas fa-phone-alt me-1"></i> Support: 08032929756
          </span>
        </div>
      </div>

      <!-- Messages -->
      <?php echo $msg; ?>

      <!-- Breadcrumbs -->
      <div class="breadcrumb-custom mb-4">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb mb-0">
            <li class="breadcrumb-item"><a href="main.php">Admin Dashboard</a></li>
            <li class="breadcrumb-item"><a href="list_admin.php">Manage Admins</a></li>
            <li class="breadcrumb-item active">Edit Admin</li>
          </ol>
        </nav>
      </div>

      <!-- Edit Admin Form -->
      <div class="card shadow mb-4">
        <div class="card-header py-3">
          <h6 class="m-0 font-weight-bold">Edit Admin Details</h6>
        </div>
        <div class="card-body">
          <form method="post" action="exe_edit_admin.php" class="form-horizontal" enctype="multipart/form-data">
            <input type="hidden" name="admin_id" value="<?php echo $admin['id']; ?>">
            
            <div class="row mb-4">
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">Admin Photo</label>
                  <div class="d-flex align-items-center">
                    <img src="profile_pic/<?php echo htmlspecialchars($admin['photo']); ?>" 
                         class="photo-preview me-3" alt="Current photo">
                    <input type="file" class="form-control" name="photo" id="photoInput" accept="image/*">
                  </div>
                  <small class="text-muted">Leave blank to keep current photo</small>
                </div>
                
                <div class="mb-3">
                  <label class="form-label">Full Name <span class="text-danger">*</span></label>
                  <input type="text" name="fullname" class="form-control" 
                         value="<?php echo htmlspecialchars($admin['fullname']); ?>" required>
                </div>
                
                <div class="mb-3">
                  <label class="form-label">Email <span class="text-danger">*</span></label>
                  <input type="email" name="email" class="form-control" 
                         value="<?php echo htmlspecialchars($admin['email']); ?>" required>
                </div>
                
                <div class="mb-3">
                  <label class="form-label">Username <span class="text-danger">*</span></label>
                  <input type="text" name="username" class="form-control" 
                         value="<?php echo htmlspecialchars($admin['username']); ?>" required>
                </div>
              </div>
              
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">New Password</label>
                  <input type="password" name="password" class="form-control" placeholder="Leave blank to keep current password">
                  <small class="text-muted">Minimum 8 characters</small>
                </div>
                
                <div class="mb-3">
                  <label class="form-label">Confirm New Password</label>
                  <input type="password" name="password2" class="form-control" placeholder="Confirm new password">
                  <div class="pass_mismatch text-danger mt-2" style="display: none;">
                    <i class="fas fa-exclamation-circle"></i> Passwords do not match!
                  </div>
                </div>
                
                <div class="mb-3">
                  <label class="form-label">Access Level <span class="text-danger">*</span></label>
                  <select name="access_level" class="form-select" required>
                    <option value="Administrator" <?php echo ($admin['access_level'] == 'Administrator') ? 'selected' : ''; ?>>Admin</option>
                    <option value="Super Admin" <?php echo ($admin['access_level'] == 'Super Admin') ? 'selected' : ''; ?>>Super Admin</option>
                  </select>
                </div>
                
                <div class="mb-3">
                  <label class="form-label">Status <span class="text-danger">*</span></label>
                  <select name="status" class="form-select" required>
                    <option value="Active" <?php echo ($admin['status'] == 'Active') ? 'selected' : ''; ?>>Active</option>
                    <option value="Inactive" <?php echo ($admin['status'] == 'Inactive') ? 'selected' : ''; ?>>Inactive</option>
                  </select>
                </div>
                
                <div class="mb-3">
                  <label class="form-label">Registration Date</label>
                  <input type="text" class="form-control" value="<?php echo htmlspecialchars($admin['registration_date']); ?>" readonly>
                </div>
              </div>
            </div>
            
            <div class="row">
              <div class="col-12 text-center">
                <button type="submit" name="submit" class="btn btn-primary btn-lg px-5 py-3 me-3">
                  <i class="fas fa-save me-2"></i>Save Changes
                </button>
                <a href="list_admin.php" class="btn btn-secondary btn-lg px-5 py-3">
                  <i class="fas fa-times me-2"></i>Cancel
                </a>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </main>

  <!-- Footer -->
  <footer class="footer">
    <div class="container-fluid">
      <div class="row align-items-center">
        <div class="col-md-6">
          <span class="copyright-text">Copyright &copy; VERBUM DEI INT'L COLLEGE <?php echo date("Y"); ?></span>
        </div>
        <div class="col-md-6">
          <div class="text-md-end">
            <a href="https://dataswift.com.ng" target="_blank" rel="noopener noreferrer" class="text-white">
              <span>Powered by DataSwift</span>
              <img src="datalogo.png" alt="DataSwift Logo" class="ms-2" height="24">
            </a>
          </div>
        </div>
      </div>
    </div>
  </footer>

  <!-- Bootstrap 5 JS Bundle with Popper -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  
  <!-- jQuery -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  
  <!-- Custom Scripts -->
  <script>
    // Toggle sidebar on mobile
    document.getElementById('sidebarToggle').addEventListener('click', function() {
        document.getElementById('sidebar').classList.toggle('active');
        document.querySelector('.main-content').classList.toggle('active');
    });
    
    // Photo preview functionality
    document.getElementById('photoInput')?.addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(event) {
                const preview = document.querySelector('.photo-preview');
                preview.src = event.target.result;
            };
            reader.readAsDataURL(file);
        }
    });
    
    // Password match validation
    $(document).ready(function() {
        $("form").submit(function(e) {
            let valid = true;
            const password = $("input[name='password']").val();
            const password2 = $("input[name='password2']").val();
            
            // Only check password match if password field is not empty
            if(password !== '' || password2 !== '') {
                if(password !== password2) {
                    $(".pass_mismatch").show();
                    $("input[name='password'], input[name='password2']").addClass('is-invalid');
                    valid = false;
                } else {
                    $(".pass_mismatch").hide();
                    $("input[name='password'], input[name='password2']").removeClass('is-invalid');
                }
            }
            
            // Check required fields
            $(this).find("[required]").each(function() {
                if(!$(this).val()) {
                    $(this).addClass('is-invalid');
                    valid = false;
                } else {
                    $(this).removeClass('is-invalid');
                }
            });
            
            if(!valid) {
                e.preventDefault();
                $('html, body').animate({
                    scrollTop: $(".is-invalid").first().offset().top - 100
                }, 500);
            }
        });
    });
  </script>
</body>
</html>