<?php
require_once('source/session.php');
require_once('source/error.php');
require_once('source/dbconfig.php');
require_once('source/function.php');
require_once('source/restrict_admin.php');

// Handle all actions (add, edit, delete, toggle status)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        $action = $_POST['action'];
        
        switch ($action) {
            case 'delete':
                // Delete teacher
                if (isset($_POST['id'])) {
                    $id = (int)$_POST['id'];
                    $result = sql($DBH, "DELETE FROM tbl_user WHERE id = ? AND teacher = ?", [$id, "true"], "count");
                    $_SESSION['msg'] = $result ? "delete_success" : "delete_failed";
                }
                break;
                
            case 'toggle_status':
                // Toggle teacher status
                if (isset($_POST['hash'])) {
                    $hash = $_POST['hash'];
                    $current_status = sql($DBH, "SELECT status FROM tbl_user WHERE hash = ?", [$hash], "rows")[0]['status'];
                    $new_status = ($current_status == "Active") ? "Inactive" : "Active";
                    
                    sql($DBH, "UPDATE tbl_user SET status = ? WHERE hash = ?", [$new_status, $hash], "count");
                    $_SESSION['msg'] = "status_toggled";
                }
                break;
        }
        
        header("Location: teachers.php");
        exit();
    }
}

// Message handling
$msg = '';
if(isset($_SESSION['msg'])) {
    $messages = [
        "delete_success" => "Teacher deleted successfully",
        "delete_failed" => "Failed to delete teacher",
        "status_toggled" => "Teacher status updated",
        "error" => "An error occurred"
    ];
    
    if(isset($messages[$_SESSION['msg']])) {
        $is_success = in_array($_SESSION['msg'], ["delete_success", "status_toggled"]);
        $alert_type = $is_success ? 'success' : 'danger';
        $msg = "<div class='alert alert-$alert_type text-center mb-4'>"
             . $messages[$_SESSION['msg']]
             . "</div>";
    }
    unset($_SESSION['msg']);
}

// Get admin full name
$admin_fullname = '';
$rows = sql($DBH, "SELECT fullname FROM tbl_admin WHERE status = ?", ["Active"], "rows");
if(!empty($rows)) {
    $admin_fullname = $rows[0]['fullname'];
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Manage Teachers - VERBUM DEI INT'L COLLEGE</title>
  <link rel="icon" type="image/png" href="https://portal.vda.com.ng/coll_admin/coll_logo.jpg">
  
  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  
  <!-- Custom CSS -->
  <style>
    :root {
      --primary-blue: #1976d2;
      --dark-blue: #0d47a1;
      --light-blue: #64b5f6;
      --accent-blue: #bbdefb;
      --bg-light: #e3f2fd;
      --text-dark: #212529;
    }
    
    body {
      font-family: 'Poppins', sans-serif;
      background-color: var(--bg-light);
      min-height: 100vh;
      display: flex;
      flex-direction: column;
    }
    
    /* Navbar Styles */
    .navbar {
      background-color: var(--primary-blue);
      box-shadow: 0 0.15rem 1.75rem 0 rgba(33, 37, 41, 0.1);
      position: fixed;
      top: 0;
      width: 100%;
      z-index: 1030;
      color: white;
    }
    
    .navbar-brand {
      font-weight: 800;
      font-size: 1.2rem;
      color: white;
    }
    
    /* Sidebar Styles */
    .sidebar {
      background: linear-gradient(180deg, var(--dark-blue) 0%, var(--primary-blue) 100%);
      position: fixed;
      top: 56px;
      left: -250px;
      width: 250px;
      height: calc(100vh - 56px);
      transition: all 0.3s;
      z-index: 1000;
      overflow-y: auto;
    }
    
    .sidebar.active {
      left: 0;
    }
    
    .sidebar .nav-link {
      color: rgba(255, 255, 255, 0.85);
      font-weight: 600;
      padding: 0.75rem 1rem;
      margin-bottom: 0.2rem;
      transition: all 0.2s;
    }
    
    .sidebar .nav-link:hover {
      color: #fff;
      background-color: rgba(255, 255, 255, 0.15);
    }
    
    .sidebar .nav-link.active {
      color: #fff;
      background-color: var(--light-blue);
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    
    .sidebar .nav-link i {
      margin-right: 0.5rem;
      width: 20px;
      text-align: center;
    }
    
    /* Main Content Styles */
    .main-content {
      margin-left: 0;
      width: 100%;
      transition: all 0.3s;
      flex: 1 0 auto;
      padding-top: 56px;
    }
    
    @media (min-width: 992px) {
      .sidebar {
        left: 0;
      }
      .main-content {
        margin-left: 250px;
        width: calc(100% - 250px);
      }
    }
    
    /* Card Styles */
    .card {
      border: none;
      border-radius: 12px;
      box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
      margin-bottom: 1.5rem;
      transition: transform 0.3s, box-shadow 0.3s;
    }
    
    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0 1rem 2rem rgba(0, 0, 0, 0.15);
    }
    
    .card-header {
      background-color: var(--accent-blue);
      border-bottom: 1px solid var(--light-blue);
      font-weight: 700;
      color: var(--dark-blue);
      padding: 1rem 1.5rem;
    }
    
    /* Button Styles */
    .btn-primary {
      background-color: var(--primary-blue);
      border-color: var(--primary-blue);
      padding: 0.5rem 1.5rem;
      font-weight: 600;
    }
    
    .btn-primary:hover {
      background-color: var(--dark-blue);
      border-color: var(--dark-blue);
    }
    
    /* Table Styles */
    .table-responsive {
      overflow-x: auto;
    }
    
    .table-hover tbody tr:hover {
      background-color: rgba(0, 0, 0, 0.03);
    }
    
    /* Admin Info Styles */
    .admin-info {
      display: flex;
      align-items: center;
      background-color: rgba(255,255,255,0.2);
      padding: 8px 12px;
      border-radius: 8px;
      color: white;
    }
    
    .admin-name {
      margin-right: 5px;
      font-weight: 600;
    }
    
    .admin-access {
      font-style: italic;
      opacity: 0.8;
      margin-right: 10px;
      font-size: 0.9rem;
    }
    
    .admin-icon {
      font-size: 1.5rem;
      color: white;
    }
    
    /* Footer styles */
    .footer {
      background-color: var(--dark-blue);
      color: white;
      padding: 20px 0;
      flex-shrink: 0;
      width: 100%;
    }
    
    @media (min-width: 992px) {
      .footer {
        margin-left: 250px;
        width: calc(100% - 250px);
      }
    }
    
    .copyright-text {
      font-weight: 600;
      font-size: 1rem;
    }
    
    /* Support badge */
    .support-badge {
      background-color: var(--accent-blue);
      color: var(--dark-blue);
      font-weight: 600;
      padding: 0.5rem 1rem;
    }
    
    /* Breadcrumbs */
    .breadcrumb-custom .breadcrumb {
      background-color: transparent;
      padding: 0;
    }
    
    .breadcrumb-custom .breadcrumb-item a {
      color: var(--primary-blue);
      text-decoration: none;
    }
    
    .breadcrumb-custom .breadcrumb-item.active {
      color: var(--dark-blue);
      font-weight: 500;
    }
    
    /* Action buttons */
    .action-btns .btn {
      min-width: 90px;
    }
    
    /* Status badge */
    .status-badge {
      padding: 0.35rem 0.5rem;
      font-size: 0.8rem;
      border-radius: 0.25rem;
    }
    
    /* Inactive row */
    .inactive-row {
      background-color: rgba(255, 193, 7, 0.15);
    }
    
    /* Modal styles */
    .modal-header {
      background-color: var(--primary-blue);
      color: white;
    }
    
    .modal-danger .modal-header {
      background-color: #dc3545;
    }
  </style>
</head>

<body>
  <!-- Top Navigation -->
  <nav class="navbar navbar-expand-lg navbar-dark">
    <div class="container-fluid">
      <button id="sidebarToggle" class="btn btn-link d-lg-none me-2">
        <i class="fas fa-bars"></i>
      </button>
      <a class="navbar-brand d-none d-lg-block" href="#">
        VERBUM DEI INT'L COLLEGE
      </a>
      <div class="ms-auto d-flex align-items-center">
        <div class="admin-info me-3">
          <span class="admin-name"><?php echo htmlspecialchars($admin_fullname); ?></span>
          <span class="admin-access">(Administrator)</span>
          <i class="fas fa-user-circle admin-icon"></i>
        </div>
        <a href="logout.php" class="btn btn-sm btn-outline-light">
          <i class="fas fa-sign-out-alt"></i>
        </a>
      </div>
    </div>
  </nav>

  <!-- Sidebar -->
  <nav id="sidebar" class="sidebar">
    <div class="position-sticky pt-3">
      <div class="text-center mb-4 d-none d-lg-block">
        <img src="https://portal.vda.com.ng/coll_admin/coll_logo.jpg" alt="School Logo" class="rounded-circle" width="80">
        <h5 class="mt-2 text-white">VERBUM DEI INT'L COLLEGE</h5>
        <p class="text-white-50 small">Admin Dashboard</p>
      </div>
      
      <ul class="nav flex-column">
        <li class="nav-item">
          <a class="nav-link" href="main.php">
            <i class="fas fa-fw fa-tachometer-alt"></i>
            Admin Centre
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_session.php">
            <i class="fas fa-fw fa-calendar-alt"></i>
            School Year/Session
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_classes.php">
            <i class="fas fa-fw fa-building"></i>
            Manage Classes
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="add_students.php">
            <i class="fas fa-fw fa-user-plus"></i>
            Register New Student
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_subjects.php">
            <i class="fas fa-fw fa-book"></i>
            Create Subjects
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link active" href="teachers.php">
            <i class="fas fa-fw fa-chalkboard-teacher"></i>
            Manage Teachers
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="students.php">
            <i class="fas fa-fw fa-users"></i>
            Manage Students
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="deactivate_students.php">
            <i class="fas fa-fw fa-user-lock"></i>
            Activate/Deactivate
          </a>
        </li>
      </ul>
    </div>
  </nav>

  <!-- Main Content -->
  <main class="main-content">
    <div class="container-fluid px-4 pt-4">
      <!-- Page Heading -->
      <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Teacher Management</h1>
        <div class="d-none d-sm-inline-block">
          <span class="badge support-badge p-2">
            <i class="fas fa-phone-alt me-1"></i> Support: 08032929756
          </span>
        </div>
      </div>

      <!-- Messages -->
      <?php echo $msg; ?>

      <!-- Breadcrumbs -->
      <div class="breadcrumb-custom mb-4">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb mb-0">
            <li class="breadcrumb-item"><a href="main.php">Admin Dashboard</a></li>
            <li class="breadcrumb-item active">Manage Teachers</li>
          </ol>
        </nav>
      </div>

      <!-- Add Teacher Button -->
      <div class="mb-4">
        <a href="add_teachers.php" class="btn btn-primary">
          <i class="fas fa-plus-circle me-2"></i> Add New Teacher
        </a>
      </div>

      <!-- Search Form -->
      <div class="card shadow mb-4">
        <div class="card-body">
          <form method="get" class="row g-3">
            <div class="col-md-8">
              <input type="text" class="form-control" name="search" placeholder="Search by name or email" 
                     value="<?php echo isset($_GET['search']) ? htmlspecialchars($_GET['search']) : ''; ?>">
            </div>
            <div class="col-md-4">
              <button type="submit" class="btn btn-primary w-100">
                <i class="fas fa-search me-2"></i> Search
              </button>
            </div>
            <?php if(isset($_GET['search'])): ?>
            <div class="col-12">
              <a href="teachers.php" class="btn btn-outline-secondary">
                <i class="fas fa-times me-2"></i> Clear Search
              </a>
            </div>
            <?php endif; ?>
          </form>
        </div>
      </div>

      <!-- Teachers Table -->
      <div class="card shadow mb-4">
        <div class="card-header py-3">
          <h6 class="m-0 font-weight-bold">Teacher List</h6>
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table class="table table-hover">
              <thead class="table-light">
                <tr>
                  <th>#</th>
                  <th>Teacher Name</th>
                  <th>Contact</th>
                  <th>Registration Date</th>
                  <th>Status</th>
                  <th>Actions</th>
                </tr>
              </thead>
              <tbody>
                <?php
                $search = isset($_GET['search']) ? strip_tags($_GET['search']) : '';
                $query = "SELECT * FROM tbl_user WHERE teacher = ?";
                $params = ["true"];
                
                if(!empty($search)) {
                    $query .= " AND (fullname LIKE ? OR email LIKE ?)";
                    $params[] = "%$search%";
                    $params[] = "%$search%";
                }
                
                $query .= " ORDER BY id DESC";
                $rows = sql($DBH, $query, $params, "rows");
                
                foreach($rows as $row):
                    // Skip specific IDs if needed
                    if ($row['id'] == 368 || $row['id'] == 378) continue;
                    
                    $status_class = ($row['status'] == "Active") ? "bg-success" : "bg-warning";
                ?>
                <tr class="<?php echo $row['status'] == 'Inactive' ? 'inactive-row' : ''; ?>">
                  <td><?php echo $row['id']; ?></td>
                  <td>
                    <strong><?php echo htmlspecialchars($row['fullname']); ?></strong><br>
                    <small class="text-muted"><?php echo htmlspecialchars($row['email']); ?></small>
                  </td>
                  <td><?php echo htmlspecialchars($row['phone']); ?></td>
                  <td><?php echo $row['registration_date']; ?></td>
                  <td>
                    <span class="badge status-badge <?php echo $status_class; ?>">
                      <?php echo $row['status']; ?>
                    </span>
                  </td>
                  <td>
                    <div class="d-flex gap-2">
                      <a href="edit_teacher.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-primary">
                        <i class="fas fa-edit me-1"></i> Edit
                      </a>
                      <form method="post" action="teachers.php" class="d-inline">
                        <input type="hidden" name="action" value="toggle_status">
                        <input type="hidden" name="hash" value="<?php echo $row['hash']; ?>">
                        <button type="submit" class="btn btn-sm <?php echo $row['status'] == 'Active' ? 'btn-warning' : 'btn-success'; ?>">
                          <i class="fas fa-power-off me-1"></i> <?php echo $row['status'] == 'Active' ? 'Deactivate' : 'Activate'; ?>
                        </button>
                      </form>
                      <button class="btn btn-sm btn-danger delete-btn" data-id="<?php echo $row['id']; ?>">
                        <i class="fas fa-trash-alt me-1"></i> Delete
                      </button>
                    </div>
                  </td>
                </tr>
                <?php endforeach; ?>
                
                <?php if(empty($rows)): ?>
                <tr>
                  <td colspan="6" class="text-center py-4">
                    <i class="fas fa-chalkboard-teacher fa-2x mb-3 text-muted"></i>
                    <p class="text-muted">No teachers found</p>
                  </td>
                </tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </main>

  <!-- Delete Confirmation Modal -->
  <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header bg-danger text-white">
          <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="teachers.php">
          <input type="hidden" name="action" value="delete">
          <input type="hidden" name="id" id="deleteId">
          <div class="modal-body">
            Are you sure you want to delete this teacher? This action cannot be undone.
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-danger">
              <i class="fas fa-trash-alt me-1"></i> Delete
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- Footer -->
  <footer class="footer">
    <div class="container-fluid">
      <div class="row align-items-center">
        <div class="col-md-6">
          <span class="copyright-text">Copyright &copy; VERBUM DEI INT'L COLLEGE <?php echo date("Y"); ?></span>
        </div>
        <div class="col-md-6">
          <div class="text-md-end">
            <a href="https://dataswift.com.ng" target="_blank" rel="noopener noreferrer" class="text-white">
              <span>Powered by DataSwift</span>
              <img src="datalogo.png" alt="DataSwift Logo" class="ms-2" height="24">
            </a>
          </div>
        </div>
      </div>
    </div>
  </footer>

  <!-- Bootstrap 5 JS Bundle with Popper -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  
  <!-- jQuery -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  
  <!-- Custom Scripts -->
  <script>
    // Toggle sidebar on mobile
    document.getElementById('sidebarToggle').addEventListener('click', function() {
        document.getElementById('sidebar').classList.toggle('active');
        document.querySelector('.main-content').classList.toggle('active');
    });
    
    // Delete modal handling
    $(document).ready(function() {
        $('.delete-btn').click(function() {
            var id = $(this).data('id');
            $('#deleteId').val(id);
            $('#deleteModal').modal('show');
        });
    });
  </script>
</body>
</html>