<?php
require_once('source/session.php');
require_once('source/error.php');
require_once('source/dbconfig.php');
require_once('source/function.php');
require_once('source/restrict_admin.php');

if(isset($_POST['submit']))
{
    try {
        $fullname = strip_tags($_POST['fullname']);
        $email = strip_tags($_POST['email']);
        $gender = strip_tags($_POST['gender']);
        $pass = strip_tags($_POST['password']);
        $password = md5(md5($salt . md5($pass)) . $salt);
        
        $class = strip_tags($_POST['class']);
        $subclass = strip_tags($_POST['subclass']);
        $subject = strip_tags($_POST['subject']);
        $phone = strip_tags($_POST['phone']);
        
        // Check if email or phone already exists
        $email_exists = sql($DBH, "SELECT COUNT(*) FROM tbl_user WHERE email = ?", [$email], "rows")[0][0];
        $phone_exists = sql($DBH, "SELECT COUNT(*) FROM tbl_user WHERE phone = ?", [$phone], "rows")[0][0];
        
        if($email_exists > 0) {
            $_SESSION['msg'] = "email";
            redirect('add_teachers.php');
        } else if($phone_exists > 0) {
            $_SESSION['msg'] = "phone";
            redirect('add_teachers.php');
        } else {
            // Insert new teacher
            sql($DBH,
                "INSERT INTO tbl_user (fullname, email, password, gender, class, subclass, subject, phone, registration_date, hash, status, teacher)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)",
                array($fullname, $email, $password, $gender, $class, $subclass, $subject, $phone, $DATE_NOW, $token, "Active", "true"));
            
            // Send email notification
            $subject_line = "APPOINTMENT LETTER FOR JOINING VERBUM DEI INT'L COLLEGE PORTAL";
            
            $message = '<html>
                <head>
                  <title>Teacher Registration - Verbum Dei Int\'l College</title>
                </head>
                <body>
                 <p>Dear '.$fullname.',</p>
                 <p>Congratulations! You have been registered on the Verbum Dei Int\'l College Portal as the form teacher or manager for <b>'.$class.'</b></p>
                 <p><b>Subject to be taken:</b><br/> '.$subject.'</p>
                 <p>Your Password is: '.$pass.'</p>
                 <p>To login, please visit: https://portal.vda.com.ng/teacher-login/</p>
                 <p>As you may know, you can upload results for all students in your class at the same time and can as well view the results you have uploaded.</p>
                 <p>Note that you cannot delete or update any result once uploaded. Kindly contact the admin for any corrections.</p>
                 <p>Should you have any questions, please contact the admin at support@portal.vda.com.ng or call 08032929756.</p>
                 <p>Thank You!</p>
                </body>
            </html>';
            
            $headers = [
                'MIME-Version: 1.0',
                'Content-type: text/html; charset=iso-8859-1',
                'To: <'.$email.'>',
                'From: VERBUM DEI INT\'L COLLEGE <admin@portal.vda.com.ng>'
            ];
            
            mail($email, $subject_line, $message, implode("\r\n", $headers));

            $_SESSION['msg'] = "signup";
            redirect('add_teachers.php');
            exit;
        }
    }
    catch(PDOException $e) { 
        file_put_contents('PDOErrors.txt', $e->getMessage(), FILE_APPEND);
        $_SESSION['msg'] = "error";
        redirect('add_teachers.php');
    }
}
else
{
    $_SESSION['msg'] = "error";
    redirect('add_teachers.php');
}