<?php
require_once('source/session.php');
require_once('source/error.php');
require_once('source/dbconfig.php');
require_once('source/function.php');
require_once('source/restrict_admin.php');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $exam_subject_id = $_POST['exam_subject_id'];
    $question_text = $_POST['question_text'];
    $option_a = $_POST['option_a'];
    $option_b = $_POST['option_b'];
    $option_c = $_POST['option_c'];
    $option_d = $_POST['option_d'];
    $correct_answer = $_POST['correct_answer'];

    try {
        // Insert question into tbl_question
        $stmt = $DBH->prepare("INSERT INTO tbl_question (exam_subject_id, question_text, option_a, option_b, option_c, option_d, correct_answer) 
                               VALUES (:exam_subject_id, :question_text, :option_a, :option_b, :option_c, :option_d, :correct_answer)");
        $stmt->execute([
            'exam_subject_id' => $exam_subject_id,
            'question_text' => $question_text,
            'option_a' => $option_a,
            'option_b' => $option_b,
            'option_c' => $option_c,
            'option_d' => $option_d,
            'correct_answer' => $correct_answer
        ]);

        $success = "Question added successfully.";
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
}

// Fetch all exam-subject combinations
$stmt = $DBH->query("
    SELECT es.id, e.exam_name, s.subject 
    FROM tbl_exam_subject es
    JOIN tbl_exam e ON es.exam_id = e.id
    JOIN tbl_subject s ON es.subject_id = s.id
");
$exam_subjects = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Question - CBT Portal</title>
    <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="text-center">Add Question</h3>
                    </div>
                    <div class="card-body">
                        <?php if (isset($success)): ?>
                            <div class="alert alert-success"><?php echo $success; ?></div>
                        <?php endif; ?>
                        <form method="POST">
                            <div class="form-group">
                                <label for="exam_subject_id">Select Exam-Subject</label>
                                <select name="exam_subject_id" class="form-control" required>
                                    <option value="">-- Select Exam-Subject --</option>
                                    <?php foreach ($exam_subjects as $es): ?>
                                        <option value="<?php echo $es['id']; ?>">
                                            <?php echo $es['exam_name'] . ' - ' . $es['subject']; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="question_text">Question</label>
                                <textarea name="question_text" class="form-control" rows="3" required></textarea>
                            </div>
                            <div class="form-group">
                                <label for="option_a">Option A</label>
                                <input type="text" name="option_a" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <label for="option_b">Option B</label>
                                <input type="text" name="option_b" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <label for="option_c">Option C</label>
                                <input type="text" name="option_c" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <label for="option_d">Option D</label>
                                <input type="text" name="option_d" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <label for="correct_answer">Correct Answer</label>
                                <select name="correct_answer" class="form-control" required>
                                    <option value="A">A</option>
                                    <option value="B">B</option>
                                    <option value="C">C</option>
                                    <option value="D">D</option>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary btn-block">Add Question</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>