<?php
require_once('source/session.php');
require_once('source/error.php');
require_once('source/dbconfig.php');
require_once('source/function.php');
require_once('source/restrict_admin.php'); 

error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_GET['batch'])) {
    die("Batch not specified");
}

$batchName = $_GET['batch'];
$pins = sql($DBH, "SELECT * FROM tbl_pin WHERE batch_id = ? ORDER BY Serial", [$batchName], "rows");

if (!$pins) {
    die("No PINs found for this batch");
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Print PIN Batch - <?php echo htmlspecialchars($batchName); ?></title>
    <style>
        @page {
            size: A4;
            margin: 10mm;
        }
        
        body {
            font-family: Arial, sans-serif;
            background-color: white;
            color: #333;
        }
        
        .header {
            text-align: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #0d47a1;
        }
        
        .school-name {
            font-size: 24px;
            font-weight: bold;
            color: #0d47a1;
        }
        
        .batch-info {
            text-align: center;
            margin-bottom: 20px;
        }
        
        .batch-title {
            font-size: 18px;
            font-weight: bold;
            color: #1976d2;
        }
        
        .pin-container {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
            margin-top: 20px;
        }
        
        .pin-card {
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 10px;
            page-break-inside: avoid;
            background-color: white;
        }
        
        .pin-code {
            font-family: 'Courier New', monospace;
            font-size: 14px;
            font-weight: bold;
            text-align: center;
            color: #002171;
            margin: 10px 0;
            letter-spacing: 1px;
        }
        
        .serial-number {
            font-size: 12px;
            color: #666;
            text-align: right;
        }
        
        .batch-name {
            font-size: 10px;
            color: #999;
            text-align: center;
            margin-top: 5px;
        }
        
        .watermark {
            position: fixed;
            bottom: 10px;
            right: 10px;
            opacity: 0.2;
            font-size: 72px;
            color: #0d47a1;
            transform: rotate(-45deg);
            z-index: -1;
        }
        
        @media print {
            .no-print {
                display: none;
            }
            
            .pin-card {
                border: 1px solid #eee;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="school-name">VERBUM DEI INTERNATIONAL COLLEGE</div>
        <div>Student Result Access PINs</div>
    </div>
    
    <div class="batch-info">
        <div class="batch-title">Batch: <?php echo htmlspecialchars($batchName); ?></div>
        <div>Total PINs: <?php echo count($pins); ?></div>
    </div>
    
    <div class="pin-container">
        <?php foreach ($pins as $pin): ?>
            <div class="pin-card">
                <div class="serial-number">R-<?php echo str_pad($pin['Serial'], 5, "0", STR_PAD_LEFT); ?></div>
                <div class="pin-code"><?php echo htmlspecialchars($pin['pin']); ?></div>
                <div class="batch-name"><?php echo htmlspecialchars($batchName); ?></div>
            </div>
        <?php endforeach; ?>
    </div>
    
    <div class="watermark no-print">VDIC</div>
    
    <div class="no-print" style="text-align: center; margin-top: 20px;">
        <button onclick="window.print()" style="padding: 10px 20px; background-color: #0d47a1; color: white; border: none; border-radius: 4px; cursor: pointer;">
            Print PINs
        </button>
        <button onclick="window.close()" style="padding: 10px 20px; background-color: #666; color: white; border: none; border-radius: 4px; cursor: pointer; margin-left: 10px;">
            Close
        </button>
    </div>
    
    <script>
        // Auto-print when page loads
        window.onload = function() {
            setTimeout(function() {
                window.print();
            }, 500);
        };
    </script>
</body>
</html>