<?php
require_once('source/session.php');
require_once('source/error.php');
require_once('source/dbconfig.php');
require_once('source/function.php');
require_once('source/restrict_admin.php');

// Message handling
$msg = '';
if(isset($_SESSION['msg'])) {
    $alert_type = 'warning'; // default
    $messages = [
        "email" => "Admission number already exists, please try another",
        "phone" => "Phone number already exists, please try another",
        "reg" => "Registration number already exists",
        "bitcoin wallet" => "Bitcoin wallet already exists",
        "account number" => "Account number already exists",
        "signup" => "Registration is successful, student can login now on the student login page",
        "captcha" => "Something went wrong, please check captcha",
        "samp" => "Samp request found, please try again",
        "incorrect" => "Incorrect Passwords! Kindly Insert Correct Password for Both",
        "forget" => "New password has been sent to your verified email",
        "no_ref" => "Invalid Reference Email",
        "no_pro" => "Invalid Promoter/Consultant Email"
    ];
    
    if(isset($messages[$_SESSION['msg']])) {
        $is_success = ($_SESSION['msg'] == "signup" || $_SESSION['msg'] == "forget");
        $alert_type = $is_success ? 'success' : 'danger';
        $msg = "<div class='alert alert-$alert_type text-center mb-4'>"
             . $messages[$_SESSION['msg']];
             
        if($_SESSION['msg'] == "signup") {
            $msg .= " <a href='/gportal/check-results/' class='btn btn-sm btn-outline-light ml-2'>Student Login</a>";
        }
        
        $msg .= "</div>";
    }
    unset($_SESSION['msg']);
}

// Get admin full name
$admin_fullname = '';
$rows = sql($DBH, "SELECT fullname FROM tbl_admin WHERE status = ?", ["Active"], "rows");
if(!empty($rows)) {
    $admin_fullname = $rows[0]['fullname'];
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Register Student - VERBUM DEI INT'L COLLEGE</title>
  <link rel="icon" type="image/png" href="https://portal.vda.com.ng/coll_admin/coll_logo.jpg">
  
  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  
  <!-- Custom CSS -->
  <style>
    :root {
      --primary-blue: #1976d2;
      --dark-blue: #0d47a1;
      --light-blue: #64b5f6;
      --accent-blue: #bbdefb;
      --bg-light: #e3f2fd;
      --text-dark: #212529;
    }
    
    body {
      font-family: 'Poppins', sans-serif;
      background-color: var(--bg-light);
      min-height: 100vh;
      display: flex;
      flex-direction: column;
    }
    
    /* Navbar Styles */
    .navbar {
      background-color: var(--primary-blue);
      box-shadow: 0 0.15rem 1.75rem 0 rgba(33, 37, 41, 0.1);
      position: fixed;
      top: 0;
      width: 100%;
      z-index: 1030;
      color: white;
    }
    
    .navbar-brand {
      font-weight: 800;
      font-size: 1.2rem;
      color: white;
    }
    
    /* Sidebar Styles */
    .sidebar {
      background: linear-gradient(180deg, var(--dark-blue) 0%, var(--primary-blue) 100%);
      position: fixed;
      top: 56px;
      left: -250px;
      width: 250px;
      height: calc(100vh - 56px);
      transition: all 0.3s;
      z-index: 1000;
      overflow-y: auto;
    }
    
    .sidebar.active {
      left: 0;
    }
    
    .sidebar .nav-link {
      color: rgba(255, 255, 255, 0.85);
      font-weight: 600;
      padding: 0.75rem 1rem;
      margin-bottom: 0.2rem;
      transition: all 0.2s;
    }
    
    .sidebar .nav-link:hover {
      color: #fff;
      background-color: rgba(255, 255, 255, 0.15);
    }
    
    .sidebar .nav-link.active {
      color: #fff;
      background-color: var(--light-blue);
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    
    .sidebar .nav-link i {
      margin-right: 0.5rem;
      width: 20px;
      text-align: center;
    }
    
    /* Main Content Styles */
    .main-content {
      margin-left: 0;
      width: 100%;
      transition: all 0.3s;
      flex: 1 0 auto;
      padding-top: 56px;
    }
    
    @media (min-width: 992px) {
      .sidebar {
        left: 0;
      }
      .main-content {
        margin-left: 250px;
        width: calc(100% - 250px);
      }
    }
    
    /* Card Styles */
    .card {
      border: none;
      border-radius: 12px;
      box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
      margin-bottom: 1.5rem;
      transition: transform 0.3s, box-shadow 0.3s;
    }
    
    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0 1rem 2rem rgba(0, 0, 0, 0.15);
    }
    
    .card-header {
      background-color: var(--accent-blue);
      border-bottom: 1px solid var(--light-blue);
      font-weight: 700;
      color: var(--dark-blue);
      padding: 1rem 1.5rem;
    }
    
    /* Button Styles */
    .btn-primary {
      background-color: var(--primary-blue);
      border-color: var(--primary-blue);
      padding: 0.5rem 1.5rem;
      font-weight: 600;
    }
    
    .btn-primary:hover {
      background-color: var(--dark-blue);
      border-color: var(--dark-blue);
    }
    
    /* Form Styles */
    .form-control, .form-select {
      height: 50px;
      border-radius: 8px;
      padding: 0.5rem 1rem;
      border: 1px solid #ced4da;
      transition: all 0.3s;
    }
    
    .form-control:focus, .form-select:focus {
      border-color: var(--light-blue);
      box-shadow: 0 0 0 0.25rem rgba(100, 181, 246, 0.25);
    }
    
    /* Admin Info Styles */
    .admin-info {
      display: flex;
      align-items: center;
      background-color: rgba(255,255,255,0.2);
      padding: 8px 12px;
      border-radius: 8px;
      color: white;
    }
    
    .admin-name {
      margin-right: 5px;
      font-weight: 600;
    }
    
    .admin-access {
      font-style: italic;
      opacity: 0.8;
      margin-right: 10px;
      font-size: 0.9rem;
    }
    
    .admin-icon {
      font-size: 1.5rem;
      color: white;
    }
    
    /* Footer styles */
    .footer {
      background-color: var(--dark-blue);
      color: white;
      padding: 20px 0;
      flex-shrink: 0;
      width: 100%;
    }
    
    @media (min-width: 992px) {
      .footer {
        margin-left: 250px;
        width: calc(100% - 250px);
      }
    }
    
    .copyright-text {
      font-weight: 600;
      font-size: 1rem;
    }
    
    /* Support badge */
    .support-badge {
      background-color: var(--accent-blue);
      color: var(--dark-blue);
      font-weight: 600;
      padding: 0.5rem 1rem;
    }
    
    /* Warning text */
    .warning-text {
      color: #dc3545;
      font-weight: 600;
    }
    
    /* Access key highlight */
    .access-key {
      font-weight: 700;
      color: var(--primary-blue);
      background-color: var(--accent-blue);
      padding: 0.2rem 0.5rem;
      border-radius: 4px;
    }
    
    /* Photo upload preview */
    .photo-preview {
      width: 120px;
      height: 120px;
      object-fit: cover;
      border-radius: 8px;
      border: 2px dashed #dee2e6;
      display: none;
    }
    
    /* Breadcrumbs */
    .breadcrumb-custom .breadcrumb {
      background-color: transparent;
      padding: 0;
    }
    
    .breadcrumb-custom .breadcrumb-item a {
      color: var(--primary-blue);
      text-decoration: none;
    }
    
    .breadcrumb-custom .breadcrumb-item.active {
      color: var(--dark-blue);
      font-weight: 500;
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
      .card-body {
        padding: 1.5rem;
      }
      
      .admin-info {
        padding: 6px 10px;
      }
      
      .admin-name, .admin-access {
        font-size: 0.8rem;
      }
    }
  </style>
</head>

<body>
  <!-- Top Navigation -->
  <nav class="navbar navbar-expand-lg navbar-dark">
    <div class="container-fluid">
      <button id="sidebarToggle" class="btn btn-link d-lg-none me-2">
        <i class="fas fa-bars"></i>
      </button>
      <a class="navbar-brand d-none d-lg-block" href="#">
        VERBUM DEI INT'L COLLEGE
      </a>
      <div class="ms-auto d-flex align-items-center">
        <div class="admin-info me-3">
          <span class="admin-name"><?php echo htmlspecialchars($admin_fullname); ?></span>
          <span class="admin-access">(Administrator)</span>
          <i class="fas fa-user-circle admin-icon"></i>
        </div>
        <a href="logout.php" class="btn btn-sm btn-outline-light">
          <i class="fas fa-sign-out-alt"></i>
        </a>
      </div>
    </div>
  </nav>

  <!-- Sidebar -->
  <nav id="sidebar" class="sidebar">
    <div class="position-sticky pt-3">
      <div class="text-center mb-4 d-none d-lg-block">
        <img src="https://portal.vda.com.ng/coll_admin/coll_logo.jpg" alt="School Logo" class="rounded-circle" width="80">
        <h5 class="mt-2 text-white">VERBUM DEI INT'L COLLEGE</h5>
        <p class="text-white-50 small">Admin Dashboard</p>
      </div>
      
      <ul class="nav flex-column">
        <li class="nav-item">
          <a class="nav-link" href="main.php">
            <i class="fas fa-fw fa-tachometer-alt"></i>
            Admin Centre
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_session.php">
            <i class="fas fa-fw fa-calendar-alt"></i>
            School Year/Session
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_classes.php">
            <i class="fas fa-fw fa-building"></i>
            Manage Classes
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link active" href="add_students.php">
            <i class="fas fa-fw fa-user-plus"></i>
            Register New Student
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="post_subjects.php">
            <i class="fas fa-fw fa-book"></i>
            Create Subjects
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="teachers.php">
            <i class="fas fa-fw fa-chalkboard-teacher"></i>
            Manage Teachers
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="students.php">
            <i class="fas fa-fw fa-users"></i>
            Manage Students
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="deactivate_students.php">
            <i class="fas fa-fw fa-user-lock"></i>
            Activate/Deactivate
          </a>
        </li>
      </ul>
    </div>
  </nav>

  <!-- Main Content -->
  <main class="main-content">
    <div class="container-fluid px-4 pt-4">
      <!-- Page Heading -->
      <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Student Registration</h1>
        <div class="d-none d-sm-inline-block">
          <span class="badge support-badge p-2">
            <i class="fas fa-phone-alt me-1"></i> Support: 08032929756
          </span>
        </div>
      </div>

      <!-- Messages -->
      <?php echo $msg; ?>

      <!-- Breadcrumbs -->
      <div class="breadcrumb-custom mb-4">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb mb-0">
            <li class="breadcrumb-item"><a href="main.php">Admin Dashboard</a></li>
            <li class="breadcrumb-item active">Register Student</li>
          </ol>
        </nav>
      </div>

      <!-- Registration Form -->
      <div class="card shadow mb-4">
        <div class="card-header py-3">
          <h6 class="m-0 font-weight-bold">Register New Student/Pupil</h6>
        </div>
        <div class="card-body">
          <div class="alert alert-warning">
            <strong><i class="fas fa-exclamation-triangle me-2"></i>Important:</strong> 
            Please double-check each form before uploading any student/pupil to the portal.
          </div>
          
          <div class="alert alert-info mb-4">
            <i class="fas fa-key me-2"></i>The <strong>Access Key</strong> for all Pupils/Students is: 
            <span class="access-key">3 3 3 3</span>
          </div>
          
          <form method="post" action="exe_add_students.php" class="form-horizontal" enctype="multipart/form-data">
            <div class="row mb-4">
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">Student Photo</label>
                  <div class="d-flex align-items-center">
                    <img id="photoPreview" class="photo-preview me-3" alt="Photo preview">
                    <input type="file" class="form-control" name="photo" id="photoInput" accept="image/*">
                  </div>
                  <small class="text-muted">Recommended size: 300x300 pixels</small>
                </div>
                
                <div class="mb-3">
                  <label class="form-label">Full Name <span class="text-danger">*</span></label>
                  <input type="text" name="fullname" class="form-control" placeholder="Surname, Firstname Othernames" required>
                </div>
                
                <div class="mb-3">
                  <label class="form-label">Admission Number <span class="text-danger">*</span></label>
                  <input type="text" name="email" class="form-control" placeholder="Assign/Enter Admission Number" required>
                </div>
                
                <div class="mb-3">
                  <label class="form-label">Phone Number</label>
                  <input type="tel" name="phone" class="form-control" placeholder="Optional">
                </div>
              </div>
              
              <div class="col-md-6">
                <div class="mb-3">
                  <label class="form-label">Gender <span class="text-danger">*</span></label>
                  <select name="gender" class="form-select" required>
                    <option value="">Select Gender</option>
                    <option value="MALE">MALE</option>
                    <option value="FEMALE">FEMALE</option>
                  </select>
                </div>
                
                <div class="mb-3">
                  <label class="form-label">Class <span class="text-danger">*</span></label>
                  <select name="class" class="form-select" required>
                    <option value="">Select Class</option>
                    <?php
                    $rows1 = sql($DBH, "SELECT * FROM tbl_class WHERE id >= ?", [1], "rows");
                    foreach($rows1 as $row1) {
                        echo "<option value='{$row1['class']}'>{$row1['class']}</option>";
                    }
                    ?>
                  </select>
                </div>
                
                <div class="mb-3">
                  <label class="form-label">Sub-Class <span class="text-danger">*</span></label>
                  <select name="subclass" class="form-select" required>
                    <option value="">Select Sub-Class</option>
                    <?php
                    $rows1 = sql($DBH, "SELECT * FROM tbl_class WHERE id >= ?", [1], "rows");
                    foreach($rows1 as $row1) {
                        echo "<option value='{$row1['subclass']}'>{$row1['subclass']}</option>";
                    }
                    ?>
                  </select>
                </div>
                
                <div class="mb-3">
                  <label class="form-label">Date of Birth <span class="text-danger">*</span></label>
                  <input type="date" name="age" class="form-control" required>
                  <small class="text-muted">Format: mm/dd/yyyy</small>
                </div>
              </div>
            </div>
            
            <div class="row">
              <div class="col-12 text-center">
                <button type="submit" name="submit" class="btn btn-primary btn-lg px-5 py-3">
                  <i class="fas fa-user-plus me-2"></i>Register Student
                </button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </main>

  <!-- Footer -->
  <footer class="footer">
    <div class="container-fluid">
      <div class="row align-items-center">
        <div class="col-md-6">
          <span class="copyright-text">Copyright &copy; VERBUM DEI INT'L COLLEGE <?php echo date("Y"); ?></span>
        </div>
        <div class="col-md-6">
          <div class="text-md-end">
            <a href="https://dataswift.com.ng" target="_blank" rel="noopener noreferrer" class="text-white">
              <span>Powered by DataSwift</span>
              <img src="datalogo.png" alt="DataSwift Logo" class="ms-2" height="24">
            </a>
          </div>
        </div>
      </div>
    </div>
  </footer>

  <!-- Bootstrap 5 JS Bundle with Popper -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  
  <!-- jQuery -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  
  <!-- Custom Scripts -->
  <script>
    // Toggle sidebar on mobile
    document.getElementById('sidebarToggle').addEventListener('click', function() {
        document.getElementById('sidebar').classList.toggle('active');
        document.querySelector('.main-content').classList.toggle('active');
    });
    
    // Photo preview functionality
    document.getElementById('photoInput').addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(event) {
                const preview = document.getElementById('photoPreview');
                preview.src = event.target.result;
                preview.style.display = 'block';
            };
            reader.readAsDataURL(file);
        }
    });
    
    // Form validation
    $(document).ready(function() {
        $(".pass_mismatch").hide();
        $("form").submit(function(e) {
            let valid = true;
            
            // Check required fields
            $(this).find("[required]").each(function() {
                if(!$(this).val()) {
                    $(this).addClass('is-invalid');
                    valid = false;
                } else {
                    $(this).removeClass('is-invalid');
                }
            });
            
            if(!valid) {
                e.preventDefault();
                alert('Please fill all required fields');
            }
        });
    });
  </script>
</body>
</html>