<?php
    require_once('source/session.php');
    require_once('source/error.php');
    require_once('source/dbconfig.php');
    require_once('source/function.php');
    
    $msg = '';
    if($SESS_FULLNAME_USER){
        $msg = "Welcome back, $SESS_FULLNAME_USER!";
    }
    else if($_SESSION['msg'] == "activated"){
        $msg = "Account activated successfully!";
    }
    else if($_GET['msg'] == "inactive"){
        $msg = "Account not active. Please contact support.";
    }
    else if($_SESSION['msg'] == "failed") {
        $msg = "Invalid registration number";
    }            
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Verbum Dei Academy | Learners' Portal</title>
    <link rel="icon" type="image/png" href="https://portal.vda.com.ng/check_Pri/vda_logo_pri.png">
    
    <!-- Font Awesome -->
    <link href="vendor/font-awesome/css/all.min.css" rel="stylesheet">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-blue: #0056b3;
            --secondary-blue: #003366;
            --accent-gold: #FFD700;
            --light-bg: #f5f8fa;
        }
        
        body {
            background: var(--light-bg);
            font-family: 'Poppins', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
        }
        
        .login-container {
            width: 100%;
            max-width: 450px;
            background: white;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        
        .login-header {
            background: linear-gradient(135deg, var(--primary-blue), var(--secondary-blue));
            color: white;
            padding: 30px;
            text-align: center;
            position: relative;
        }
        
        .school-logo {
            width: 100px;
            height: 100px;
            object-fit: contain;
            margin-bottom: 15px;
            background: white;
            padding: 10px;
            border-radius: 50%;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        
        .login-title {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 5px;
        }
        
        .login-body {
            padding: 30px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .input-field {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 1rem;
            transition: all 0.3s;
        }
        
        .input-field:focus {
            border-color: var(--primary-blue);
            box-shadow: 0 0 0 3px rgba(0, 86, 179, 0.1);
        }
        
        .btn-login {
            width: 100%;
            padding: 12px;
            background: var(--primary-blue);
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 1rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .btn-login:hover {
            background: var(--secondary-blue);
            transform: translateY(-2px);
        }
        
        .support-link {
            display: block;
            text-align: center;
            margin-top: 20px;
            color: var(--primary-blue);
            text-decoration: none;
        }
        
        .copyright {
            text-align: center;
            margin-top: 20px;
            font-size: 0.8rem;
            color: #666;
        }
        
        .alert-message {
            padding: 12px;
            margin-bottom: 20px;
            border-radius: 5px;
            text-align: center;
            background: #f8f9fa;
            border-left: 4px solid var(--primary-blue);
        }
    </style>
</head>

<body>
    <div class="login-container">
        <div class="login-header">
            <img src="https://portal.vda.com.ng/check_Pri/vda_logo_pri.png" alt="Verbum Dei Academy" class="school-logo">
            <h1 class="login-title">Learners' Result Portal</h1>
            <p>NURSERY & PRIMARY SCHOOL</p>
        </div>
        
        <div class="login-body">
            <?php if(!empty($msg)): ?>
                <div class="alert-message">
                    <?= $msg ?>
                </div>
            <?php endif; ?>
            
            <form method="post" action="exe_signin.php">
                <div class="form-group">
                    <input type="text" name="username" class="input-field" placeholder="Enter Registration Number" required autofocus>
                </div>
                
                <!-- Hidden password field with default value "3333" -->
                <input type="hidden" name="password" value="3333">
                
                <button type="submit" name="signin" class="btn-login">
                    <i class="fas fa-sign-in-alt"></i> Access Result
                </button>
            </form>
            
            <a href="tel:+2348032929756" class="support-link">
                <i class="fas fa-phone-alt"></i> Contact Support: <span style="color:green">08032929756</span>
            </a>
            
            <div class="copyright">
                © <?= date('Y') ?> Verbum Dei Academy
            </div>
        </div>
    </div>
</body>
</html>