<?php
    require_once('source/session.php');
    require_once('source/error.php');
    require_once('source/dbconfig.php');
    require_once('source/function.php');
    require_once('source/restrict_user.php');
    
    // Function to check results status
    function checkResultsStatus($DBH, $year, $term, $class) {
        // First check for specific class configuration
        $specific_check = sql($DBH, 
            "SELECT status FROM tbl_results_status 
             WHERE year = ? AND term = ? AND class = ? 
             LIMIT 1", 
            [$year, $term, $class], "rows");
        
        if(!empty($specific_check)) {
            return $specific_check[0]['status'];
        }
        
        // Check for general configuration (all classes for this year/term)
        $general_check = sql($DBH, 
            "SELECT status FROM tbl_results_status 
             WHERE year = ? AND term = ? AND class IS NULL 
             LIMIT 1", 
            [$year, $term], "rows");
        
        if(!empty($general_check)) {
            return $general_check[0]['status'];
        }
        
        // No configuration found - default to Active
        return 'Active';
    }
    
    // Function to check if class is Pre-Nursery or Reception
    function isPreNurseryClass($className) {
        $className = strtoupper(trim($className));
        return (strpos($className, 'PRE-NUR') === 0 || strpos($className, 'RECEPTION') === 0);
    }
    
    if(isset($_POST['check'])) {
        try {
            // Sanitize and validate input
            $st_pin = strip_tags($_POST['pin']);
            $st_class = strip_tags($_POST['mclass']);
            $st_reg = strip_tags($_POST['registration_no']);
            $st_year = strip_tags($_POST['year']);
            $st_term = strip_tags($_POST['term']);
            
            $is_pre_nur_class = isPreNurseryClass($st_class);
            
            // Validate PIN exists
            $STH = $DBH->prepare("SELECT count(*) FROM tbl_pin WHERE pin = ?");
            $result = $STH->execute(array($st_pin));
            $count_pin = $STH->fetchColumn();
            
            if($count_pin > 0) {  
                // Get PIN details
                $rows1 = sql($DBH, "SELECT * FROM tbl_pin WHERE pin = ?", array($st_pin), "rows");                            
                foreach($rows1 as $row1) {    
                    $st_reg_no = $row1['reg_no'];
                    $st_thisclass = $row1['class'];
                    $st_thisterm = $row1['term'];
                    $st_thisyear = $row1['year'];
                }
                
                // PIN is unused - assign to this student
                if($st_reg_no == "") {
                    sql($DBH, "UPDATE tbl_pin SET reg_no = ?, class = ?, term = ?, year = ? WHERE pin = ?", 
                        array($st_reg, $st_class, $st_term, $st_year, $st_pin));
                    
                    // Check results status before redirecting
                    $results_status = checkResultsStatus($DBH, $st_year, $st_term, $st_class);
                    
                    if($results_status == 'Hold') {
                        // Store session data for display on hold page
                        $_SESSION['student_name'] = $st_reg;
                        $_SESSION['student_reg'] = $st_reg;
                        $_SESSION['class'] = $st_class;
                        $_SESSION['term'] = $st_term;
                        $_SESSION['year'] = $st_year;
                        $_SESSION['pin'] = $st_pin;
                        
                        redirect("result_on_hold.php?class=" . urlencode($st_class) . 
                                "&term=" . urlencode($st_term) . 
                                "&year=" . urlencode($st_year) . 
                                "&pin=" . urlencode($st_pin));
                        exit;
                    }
                    
                    // Redirect to appropriate results page based on class type
                    if ($is_pre_nur_class) {
                        redirect("my_pre_nur_results.php?msg=results&mypin=$st_pin&term=$st_term&myreg=$st_reg&examyear=$st_year&myclass=$st_class");
                    } else {
                        redirect("my_results.php?msg=results&mypin=$st_pin&term=$st_term&myreg=$st_reg&examyear=$st_year&myclass=$st_class");
                    }
                    exit;
                } 
                // PIN is already assigned to this student for this session
                else if($st_reg_no == $st_reg) {
                    // Check if the PIN was originally for a Pre-Nursery class
                    $pin_is_pre_nur = isPreNurseryClass($st_thisclass);
                    
                    // Check results status before redirecting
                    $results_status = checkResultsStatus($DBH, $st_year, $st_term, $st_class);
                    
                    if($results_status == 'Hold') {
                        // Store session data for display on hold page
                        $_SESSION['student_name'] = $st_reg;
                        $_SESSION['student_reg'] = $st_reg;
                        $_SESSION['class'] = $st_class;
                        $_SESSION['term'] = $st_term;
                        $_SESSION['year'] = $st_year;
                        $_SESSION['pin'] = $st_pin;
                        
                        redirect("result_on_hold.php?class=" . urlencode($st_class) . 
                                "&term=" . urlencode($st_term) . 
                                "&year=" . urlencode($st_year) . 
                                "&pin=" . urlencode($st_pin));
                        exit;
                    }
                    
                    // Determine which results page to redirect to
                    // If current class is Pre-Nursery OR the PIN was originally for Pre-Nursery
                    if ($is_pre_nur_class || $pin_is_pre_nur) {
                        // For consistency, use current class type for redirection
                        if ($is_pre_nur_class) {
                            redirect("my_pre_nur_results.php?msg=results&mypin=$st_pin&term=$st_term&myreg=$st_reg&examyear=$st_year&myclass=$st_class");
                        } else {
                            // This shouldn't normally happen, but fallback to regular results
                            redirect("my_results.php?msg=results&mypin=$st_pin&term=$st_term&myreg=$st_reg&examyear=$st_year&myclass=$st_class");
                        }
                    } else {
                        redirect("my_results.php?msg=results&mypin=$st_pin&term=$st_term&myreg=$st_reg&examyear=$st_year&myclass=$st_class");
                    }
                    exit;
                } 
                // PIN is assigned to someone else or different session
                else {
                    redirect("main.php?msg=PINfailed");
                    exit;
                }
            } 
            // Invalid PIN
            else {
                redirect("main.php?msg=failed");
                exit;
            }
        }
        catch(PDOException $e) { 
            file_put_contents('PDOErrors.txt', $e->getMessage(), FILE_APPEND);
            redirect('main.php?msg=failed');
        }
    } 
    // Form not submitted properly
    else {
        redirect('main.php?msg=failed');
    }
?>