<?php
require_once('source/dbconfig.php');
require_once('source/function.php');

session_start();

// Verify user is logged in and has selected an exam
if (!isset($_SESSION['student']) || !isset($_GET['exam_subject_id'])) {
    header("Location: cbt_index.php");
    exit();
}

// Get exam subject details
try {
    $stmt = $DBH->prepare("
        SELECT es.*, s.subject, e.exam_name, e.exam_description, ec.class
        FROM tbl_exam_subject es
        JOIN tbl_subject s ON es.subject_id = s.id
        JOIN tbl_exam e ON es.exam_id = e.id
        JOIN tbl_exam_class ec ON es.exam_id = ec.exam_id
        WHERE es.id = :exam_subject_id
        AND ec.class = :class
        AND ec.term = :term
        AND ec.session = :session
    ");
    
    $stmt->execute([
        'exam_subject_id' => $_GET['exam_subject_id'],
        'class' => $_SESSION['exam_info']['class'],
        'term' => $_SESSION['exam_info']['term'],
        'session' => $_SESSION['exam_info']['session']
    ]);
    
    $examSubject = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$examSubject) {
        throw new Exception("Invalid exam selected for your class");
    }
    
    // Check if exam is already completed
    $stmt = $DBH->prepare("
        SELECT id FROM tbl_cbt_results
        WHERE registration_no = :reg_no
        AND subject = :subject
        AND term = :term
        AND session = :session
    ");
    $stmt->execute([
        'reg_no' => $_SESSION['student']['registration_no'],
        'subject' => $examSubject['subject'],
        'term' => $_SESSION['exam_info']['term'],
        'session' => $_SESSION['exam_info']['session']
    ]);
    
    if ($stmt->fetch()) {
        header("Location: welcome.php");
        exit();
    }
    
    // Store exam details in session
    $_SESSION['current_exam'] = [
        'exam_subject_id' => $examSubject['id'],
        'exam_class_id' => $examSubject['exam_class_id'], // Added from your structure
        'subject_id' => $examSubject['subject_id'],
        'subject_name' => $examSubject['subject'],
        'duration' => $examSubject['duration_minutes'],
        'start_time' => time(),
        'class' => $examSubject['class'] // Added for reference
    ];
    
} catch (Exception $e) {
    die("Error: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Exam Instructions - CBT Portal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .instruction-card {
            max-width: 800px;
            margin: 0 auto;
            border-left: 4px solid #17a2b8;
        }
        .rule-list {
            list-style-type: none;
            padding-left: 0;
        }
        .rule-list li {
            padding: 8px 0;
            border-bottom: 1px solid #eee;
        }
        .rule-list li:last-child {
            border-bottom: none;
        }
    </style>
</head>
<body>
    <div class="container py-4">
        <div class="instruction-card card">
            <div class="card-header bg-info text-white">
                <h3 class="mb-0">Exam Instructions</h3>
            </div>
            <div class="card-body">
                <h4 class="card-title"><?= htmlspecialchars($examSubject['subject']) ?></h4>
                <p class="card-text"><?= htmlspecialchars($examSubject['exam_description']) ?></p>
                
                <div class="exam-meta mb-3">
                    <span class="badge bg-primary"><?= htmlspecialchars($examSubject['class']) ?></span>
                    <span class="badge bg-secondary"><?= htmlspecialchars($_SESSION['exam_info']['term']) ?></span>
                    <span class="badge bg-success"><?= htmlspecialchars($_SESSION['exam_info']['session']) ?></span>
                </div>
                
                <h5 class="mt-4">Important Rules:</h5>
                <ul class="rule-list">
                    <li>✔ The exam contains multiple choice questions</li>
                    <li>✔ You have <?= $examSubject['duration_minutes'] ?> minutes to complete</li>
                    <li>✔ The timer will start when you click "Begin Exam"</li>
                    <li>✔ Once started, you cannot pause the exam</li>
                    <li>✔ Use the Next/Previous buttons to navigate</li>
                    <li>✔ Answers are saved automatically</li>
                    <li>✔ The exam will auto-submit when time expires</li>
                    <li>❌ Do not refresh the page during the exam</li>
                    <li>❌ Do not navigate away from the exam page</li>
                </ul>
                
                <div class="alert alert-warning mt-4">
                    <h5 class="alert-heading">Warning!</h5>
                    <p class="mb-0">Any attempt to cheat will result in automatic disqualification.</p>
                </div>
                
                <div class="d-grid gap-2 mt-4">
                    <a href="cbt_exam.php?exam_subject_id=<?= $examSubject['id'] ?>" class="btn btn-primary btn-lg">
                        Begin Exam
                    </a>
                    <a href="welcome.php" class="btn btn-outline-secondary">
                        Back to Dashboard
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>